-- This is the city code. Search the code for your city on http://weather.yahoo.com/
set CityCode to 2442047

-- Temperature format, F or C
set t_format to "F"

-- Say tomorrow's forecast, Y or N
set say_tomorrow to "N"





--downloading the file using curl
set IURL to "http://weather.yahooapis.com/forecastrss?w=" & CityCode
set file_content to (do shell script "curl " & IURL)

--looking for the line with actual condition
set theText to text ((offset of "yweather:condition" in file_content) + 1) thru -1 of file_content
set sub_1 to text ((offset of "\"" in theText) + 1) thru -1 of theText

--today conditions found
set actual_condition to text 1 thru ((offset of "\"" in sub_1) - 1) of sub_1

--looking for actual temperature temperature
set sub_1a to text ((offset of "temp=" in sub_1)) thru -1 of sub_1
set sub_1b to text ((offset of "\"" in sub_1a) + 1) thru -1 of sub_1a
set actual_temp to text 1 thru ((offset of "\"" in sub_1b) - 1) of sub_1b

if t_format is equal to "C" then
	set actual_temp to (5 / 9) * (actual_temp - 32) as integer
end if

--looking for today forecast
set theText to text ((offset of "yweather:forecast" in file_content) + 1) thru -1 of file_content
set sub_2 to text ((offset of "\"" in theText) + 1) thru -1 of theText

--maximum and minimum temperatures found
set today_min_temp to word 9 of sub_2
set today_max_temp to word 12 of sub_2
if t_format is equal to "C" then
	set today_min_temp to (5 / 9) * (today_min_temp - 32) as integer
	set today_max_temp to (5 / 9) * (today_max_temp - 32) as integer
end if

--looking for today forecast condition (a bit tricky)
set sub_3 to text ((offset of "text" in sub_2) + 1) thru -1 of sub_2
set sub_4 to text ((offset of "\"" in sub_3) + 1) thru -1 of sub_3
set today_forecast to text 1 thru ((offset of "\"" in sub_4) - 1) of sub_4

--looking for tomorrow forecast
set sub_5 to text ((offset of "yweather:forecast" in sub_4) + 1) thru -1 of sub_4
set sub_6 to text ((offset of "\"" in sub_5) + 1) thru -1 of sub_5

--maximum and minimum temperatures found
set tomorrow_min_temp to word 9 of sub_6
set tomorrow_max_temp to word 12 of sub_6
if t_format is equal to "C" then
	set tomorrow_min_temp to (5 / 9) * (tomorrow_min_temp - 32) as integer
	set tomorrow_max_temp to (5 / 9) * (tomorrow_max_temp - 32) as integer
end if

--looking for tomorrow forecast condition (a bit tricky)
set sub_7 to text ((offset of "text" in sub_6) + 1) thru -1 of sub_6
set sub_8 to text ((offset of "\"" in sub_7) + 1) thru -1 of sub_7
set tomorrow_forecast to text 1 thru ((offset of "\"" in sub_8) - 1) of sub_8

--VoiceOver Section
say "Outside it is, " & actual_condition & ", and " & actual_temp & " degrees."
say "Today will be " & today_forecast & ", between " & today_min_temp & " and " & today_max_temp & " degrees."
if say_tomorrow is equal to "Y" then
	say "Tomorrow will be " & tomorrow_forecast & ", and between " & tomorrow_min_temp & " and " & tomorrow_max_temp & " degrees."
end if


-- Based on the Script form http://www.userbytes.com/make-your-mac-tell-you-weather-and-time/